#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Fake ReflectionsMod01.fsh   by   fizzer 
//https://www.shadertoy.com/view/4d2Xzh
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define MAX_REFLECTION_DEPTH 4

float time;

float hash(float n)
{
    return fract(sin(n) * 43758.5453);
}

float noise(vec2 p)
{
    return hash(p.x + p.y * 57.0);
}

float smoothNoise2(vec2 p)
{
    vec2 p0 = floor(p + vec2(0.0, 0.0));
    vec2 p1 = floor(p + vec2(1.0, 0.0));
    vec2 p2 = floor(p + vec2(0.0, 1.0));
    vec2 p3 = floor(p + vec2(1.0, 1.0));
    vec2 pf = fract(p);
    return mix( mix(noise(p0), noise(p1), pf.x), 
              	mix(noise(p2), noise(p3), pf.x), pf.y);
}

vec2 cellPoint(vec2 cell)
{
    return vec2(noise(cell) + cos(time + cell.y) * 0.3,
                noise(cell*0.3) + sin(time + cell.x) * 0.3);
}

vec4 circles(vec2 t, out float rad, out float idx)
{
    vec2 p = floor(t);
    float nd = 1e10;
    vec2 nc;
    vec2 nq;

    for(int y = -1; y < 2; y += 1)
        for(int x = -1; x < 2; x += 1)
        {
            vec2 b = vec2(float(x), float(y));
            vec2 q = b + p;
            vec2 c = q + cellPoint(q);
            vec2 r = c - t;

            float d = dot(r, r);

            if(d < nd)
            {
                nd = d;
                nc = c;
                nq = q;
            }
        }

    rad = 1.0;
    idx = nq.x + nq.y * 119.0;

    for(int y = -1; y < 2; y += 1)
        for(int x = -1; x < 2; x += 1)
        {
            if(x==0 && y==0)
                continue;

            vec2 b = vec2(float(x), float(y));
            vec2 q = b + nq;
            vec2 c = q + cellPoint(q);

            rad = min(rad, distance(nc, c) * 0.5);
        }

    return vec4((t - nc) / rad, nc);
}

vec2 cmul(vec2 z0,vec2 z1)
{
    return vec2(z0.x * z1.x - z0.y * z1.y, z0.x * z1.y + z0.y * z1.x);
}

vec2 cdiv(vec2 z0,vec2 z1)
{
    vec2 z1conj = vec2(z1.x, -z1.y);
    vec2 n = cmul(z0, z1conj);
    vec2 d = cmul(z1, z1conj);
    return n / d.x;
}

vec2 cinv(vec2 z)
{
    return cdiv(vec2(1.0,0.0),z);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    time = iTime;
    fragColor = vec4(0.0, 0.0, 0.0, 1.0);

    vec2 tt = (fragCoord.xy / iResolution.y - vec2(0.5)) * (4.0 - 3.0 * iMouse.x / iResolution.x);
    float b = 1.0;

    for(int i = 0; i < (MAX_REFLECTION_DEPTH + 1);i += 1)
    {
        float rad, idx;
        vec4 c = circles(tt, rad, idx);
        float z = 1.0 - dot(c.xy, c.xy);

        if(z<0.0)
        {
            float sh = mix(0.7, 1.0, smoothstep(0.0, 0.3, length(c.xy) - 0.95));
            fragColor.rgb += sh * b * mix(0.1, 0.5, step(fract(tt.x + 0.5 * step(0.5, fract(tt.y))), 0.5));
            break;
        }

        vec3 n = normalize(vec3(c.xy,z * 1.5));
        vec3 diff = mix(vec3(0.0), mix(vec3(0.25, 1.0, 0.5), vec3(0.25, 0.25, 1.0), 0.5 + 0.5 * cos(idx * 12.0)),
                      0.8 + 0.2 * (smoothNoise2(n.xy * 128.0) + 0.5 * smoothNoise2(n.xy * 256.0)));
        float m = 1.0  -smoothstep(0.99, 1.0, length(c.xy));
        fragColor.rgb += (vec3(0.1, 0.1, 0.2) * 0.1 + vec3(1.0, 1.0, 0.7) * diff * (0.4 + n.y * 0.4) +
                             		pow(0.5 + 0.5 * dot(n, normalize(vec3(1.0))), 8.0)) * b * m;
        b *= pow(1.0 - n.z, 1.3) * 0.7;
        tt = cinv(c.xy * vec2(1.0, -1.0)) * rad + c.zw;
    }
    
    fragColor.rgb = sqrt(fragColor.rgb);

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

